<?php

class UzytkownikController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->getMenu();
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + delete',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','getClassesBySchool','getCompaniesByClass','view','changeCompany'),
				'roles'=>array('admin', 'schoolAdmin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Uzytkownik;

		$schools = Szkola::model()->findAll();

		if(isset($_POST['Uzytkownik']))
		{
			$model->attributes = $_POST['Uzytkownik'];
			$model->haslo = ' ';//spacja - w oracle pusty string to null

			if($model->validate())
			{
				$model->save(false);

				if(!empty($_POST['Uzytkownik']['haslo']))
					$model->haslo = hash('sha1', $_POST['Uzytkownik']['haslo']);
				$model->save(false);

				$fields = Dziedzina::model()->findAll();

				foreach($fields as $field)
				{
					$companyField = new DziedzinaUzytkownika();
					$companyField->idUzytkownika = $model->id;
					$companyField->idDziedziny = $field->id;
					$companyField->save(false);
				}

				$this->redirect(array('admin'));
			}
		}

		$model->haslo = '';

		$this->render('create', array(
			'model'=>$model,
			'schools'=>$schools
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = Uzytkownik::model()->with('klasa')->findByPk($id);

		$classese = Yii::app()->user->getState('classes');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($classese) && !in_array($model->idKlasy, Yii::app()->user->getState('classes')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$currentPassword = $model->haslo;
		$model->schoolId = $model->klasa->idSzkoly;

		$schools = Szkola::model()->findAll();

		if(isset($_POST['Uzytkownik']))
		{
			$model->attributes = $_POST['Uzytkownik'];

			if(!empty($model->haslo))
				$model->haslo = hash('sha1', $model->haslo);
			else
				$model->haslo = $currentPassword;

			if($model->save())
				$this->redirect(array('admin'));
		}

		$model->haslo = '';

		$this->render('update',array(
			'model'=>$model,
			'schools'=>$schools
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$model = $this->loadModel($id);

		try
		{
			$model->delete();
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Uzytkownik('search');
		$model->unsetAttributes();
		$model->dbCriteria->addCondition('"klasa"."czyTestowa" != 1');

//		if(Yii::app()->user->role == 'schoolAdmin' && Yii::app()->user->getState('schoolId'))

		if(isset($_GET['Uzytkownik']))
			$model->attributes = $_GET['Uzytkownik'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	public function actionGetClassesBySchool($schoolId)
	{
		$classes = Szkola::getClasses($schoolId);
		echo json_encode($classes);
	}

	public function actionGetCompaniesByClass($classId)
	{
//		$companies = Klasa::getCompanies($classId);

		$companies = Firma::model()->findAllByAttributes(array('idKlasy'=>$classId), array('order' => '"nazwa"'));

		$result = array();

		foreach($companies as $company)
		{
			$sql = 'SELECT "imie" || \' \' || "nazwisko" AS imieNazwisko FROM "Uzytkownik" WHERE "status" = 1 AND "idKlasy" = ' .$classId . 'AND "idFirmy" = '. $company->id;
			$usersForClass = Yii::app()->db->createCommand($sql)->queryAll();

			$usersString = null;
			foreach($usersForClass as $i => $userName)
				$usersString .= $userName['IMIENAZWISKO'] . ', ';

			$nazwa = $company->nazwa;
			if($usersString !== null)
			{
				$usersString = substr($usersString, 0, -2);
				$nazwa = $company->nazwa . ' - ' . $usersString;
			}

			$result[] = array('id'=>$company->id,'nazwa'=>$nazwa);
		}

		echo json_encode($result);
	}

	public function actionView($id)
	{
		$model=Uzytkownik::model()->findByPk($id);

		$classese = Yii::app()->user->getState('classes');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($classese) && !in_array($model->idKlasy, Yii::app()->user->getState('classes')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$this->render('view',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Uzytkownik::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		$classese = Yii::app()->user->getState('classes');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($classese) && !in_array($model->idKlasy, Yii::app()->user->getState('classes')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		return $model;
	}

	public function actionChangeCompany($id)
	{
		$model = Uzytkownik::model()->findByPk($id);

		$firmy = Firma::model()->findAllByAttributes(array('idKlasy'=>$model->idKlasy));

		if(isset($_POST['companyId']) && !empty($_POST['companyId']))
		{
			$selectedCompanyId = $_POST['companyId'];

			if($selectedCompanyId !== $model->idFirmy)
			{
				$user = new Uzytkownik();
				$user->attributes = $model->attributes;
				$user->idFirmy = $selectedCompanyId;
				$user->id = null;

				$model->status = Uzytkownik::USER_STATUS_EXCLUDED;
				$model->email .= '--moved1';

				$user->save(false);
				$model->save(false);

				//dane do przekopiowania
				$dziedziny = DziedzinaUzytkownika::model()->findAllByAttributes(array('idUzytkownika' => $model->id));
				$formularze = FormularzUzytkownika::model()->findAllByAttributes(array('idUzytkownika' => $model->id));
				$akcje = AkcjaUzytkownika::model()->findAllByAttributes(array('idUzytkownika' => $model->id));

				foreach($dziedziny as $dziedzina)
				{
					$dziedzinaNowa = new DziedzinaUzytkownika();
					$dziedzinaNowa->attributes = $dziedzina->attributes;
					$dziedzinaNowa->idUzytkownika = $user->id;
					$dziedzinaNowa->id = null;
					$dziedzinaNowa->save(false);
				}

				foreach($formularze as $form)
				{
					$formNowy = new FormularzUzytkownika();
					$formNowy->attributes = $form->attributes;
					$formNowy->idUzytkownika = $user->id;
					$formNowy->id = null;
					$formNowy->save(false);
				}

				foreach($akcje as $akcja)
				{
					$akcjaNowa = new AkcjaUzytkownika();
					$akcjaNowa->attributes = $akcja->attributes;
					$akcjaNowa->idUzytkownika = $user->id;
					$akcjaNowa->idFirmy = $selectedCompanyId;
					$akcjaNowa->id = null;
					$akcjaNowa->save(false);
				}

				$this->redirect(array('/administration/uzytkownik/view', 'id'=>$user->id));
			}

			$this->redirect(array('/administration/uzytkownik/view', 'id'=>$model->id));
		}

		$this->render('changeCompany', array(
			'model'=>$model,
			'firmy'=>$firmy,
		));
	}
}
